/*
 * Decompiled with CFR 0.152.
 */
package org.ladysnake.blabber.impl.client;

import com.google.common.collect.ImmutableList;
import net.minecraft.class_1661;
import net.minecraft.class_1921;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4588;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import org.joml.Matrix4f;
import org.joml.Vector2i;
import org.ladysnake.blabber.api.client.BlabberDialogueScreen;
import org.ladysnake.blabber.api.layout.DefaultLayoutParams;
import org.ladysnake.blabber.api.layout.Margins;
import org.ladysnake.blabber.impl.common.DialogueScreenHandler;
import org.ladysnake.blabber.impl.common.machine.AvailableChoice;
import org.ladysnake.blabber.impl.common.model.IllustrationAnchor;

public class BlabberRpgDialogueScreen
extends BlabberDialogueScreen<DefaultLayoutParams> {
    public static final int INSTRUCTIONS_BOTTOM_MARGIN = 6;
    public static final int TEXT_TOP_MARGIN = 12;
    protected int choiceListMaxY;

    public BlabberRpgDialogueScreen(DialogueScreenHandler handler, class_1661 inventory, class_2561 title) {
        super(handler, inventory, title);
        this.selectionIconTexture = (class_2960)DIALOGUE_ARROWS.get(1);
        this.lockIconTexture = (class_2960)DIALOGUE_LOCKS.get(2);
        this.choiceColor = 0xD0D0D0;
        this.lockedChoiceColor = 0xA0A0A0;
        this.selectedChoiceColor = 0xF0F066;
    }

    @Override
    protected void computeMargins() {
        super.computeMargins();
        Margins mainTextMargins = ((DefaultLayoutParams)this.params()).getMainTextMargins();
        this.choiceListMaxWidth = 150;
        this.mainTextMaxWidth = Math.min(400, this.field_22789) - mainTextMargins.left() - mainTextMargins.right();
        this.instructionsMinY = this.field_22790 - 6 - this.field_22793.method_44378((class_5348)this.instructions, this.field_22789 - 5);
        this.mainTextMinY = this.field_22790 - 60 - mainTextMargins.bottom();
        this.mainTextMinX = Math.max(mainTextMargins.left(), this.field_22789 / 2 - Math.min(this.field_22793.method_27525((class_5348)((DialogueScreenHandler)this.field_2797).getCurrentText()), this.mainTextMaxWidth) / 2);
        ((Vector2i)this.illustrationSlots.get((Object)IllustrationAnchor.BEFORE_MAIN_TEXT)).set(Math.max(mainTextMargins.left(), this.field_22789 / 2 - this.mainTextMaxWidth / 2), this.field_22790 - 60);
        this.choiceListMinY = this.choiceListMaxY = this.mainTextMinY - 25 - mainTextMargins.top();
        for (AvailableChoice choice : ((DialogueScreenHandler)this.field_2797).getAvailableChoices()) {
            this.choiceListMinY -= this.field_22793.method_44378((class_5348)choice.text(), this.choiceListMaxWidth) + this.choiceGap;
        }
        this.choiceListMinX = this.field_22789 - this.choiceListMaxWidth;
        this.selectionIconMinX = this.choiceListMinX - this.selectionIconSize - 4;
    }

    @Override
    protected void layoutIllustrationAnchors() {
        ((Vector2i)this.illustrationSlots.get((Object)IllustrationAnchor.SPOT_1)).set(this.field_22789 / 4, this.mainTextMinY - 12);
        ((Vector2i)this.illustrationSlots.get((Object)IllustrationAnchor.SPOT_2)).set((this.choiceListMinX + this.field_22789) / 2, this.choiceListMinY * 3 / 4);
    }

    @Override
    protected boolean shouldSelectChoice(double mouseX, double mouseY, int choiceY, int choiceHeight, int choiceWidth) {
        return mouseX > (double)(this.choiceListMinX - 4) && mouseX <= (double)this.field_22789 && mouseY > (double)choiceY && mouseY < (double)(choiceY + choiceHeight);
    }

    public void method_52752(class_332 context) {
        int y = this.choiceListMinY;
        ImmutableList<AvailableChoice> availableChoices = ((DialogueScreenHandler)this.field_2797).getAvailableChoices();
        for (int i = 0; i < availableChoices.size(); ++i) {
            AvailableChoice choice = (AvailableChoice)availableChoices.get(i);
            int strHeight = this.field_22793.method_44378((class_5348)choice.text(), this.choiceListMaxWidth);
            BlabberRpgDialogueScreen.fillHorizontalGradient(context, this.choiceListMinX - 2, y, this.field_22789, y + strHeight, -1072689136, -2146430960);
            if (i == this.selectedChoice) {
                this.selectionIconMarginTop = (strHeight - 9) / 2 - 4;
            }
            y += strHeight + this.choiceGap;
        }
        context.method_51452();
        context.method_25296(0, this.mainTextMinY - 20, this.field_22789, this.mainTextMinY - 12, 0x101010, -1072689136);
        context.method_25296(0, this.mainTextMinY - 12, this.field_22789, this.field_22790, -1072689136, -804253680);
    }

    public static void fillHorizontalGradient(class_332 context, int startX, int startY, int endX, int endY, int colorStart, int colorEnd) {
        boolean z = false;
        int verticalPadding = 2;
        class_4588 vertexConsumer = context.method_51450().getBuffer(class_1921.method_51784());
        float a0 = (float)class_5253.class_5254.method_27762((int)colorStart) / 255.0f;
        float r0 = (float)class_5253.class_5254.method_27765((int)colorStart) / 255.0f;
        float g0 = (float)class_5253.class_5254.method_27766((int)colorStart) / 255.0f;
        float b0 = (float)class_5253.class_5254.method_27767((int)colorStart) / 255.0f;
        float a1 = (float)class_5253.class_5254.method_27762((int)colorEnd) / 255.0f;
        float r1 = (float)class_5253.class_5254.method_27765((int)colorEnd) / 255.0f;
        float g1 = (float)class_5253.class_5254.method_27766((int)colorEnd) / 255.0f;
        float b1 = (float)class_5253.class_5254.method_27767((int)colorEnd) / 255.0f;
        Matrix4f matrix4f = context.method_51448().method_23760().method_23761();
        vertexConsumer.method_22918(matrix4f, (float)startX, (float)startY - 2.0f, 0.0f).method_22915(r1, g1, b1, a1);
        vertexConsumer.method_22918(matrix4f, (float)startX, (float)startY, 0.0f).method_22915(r0, g0, b0, a0);
        vertexConsumer.method_22918(matrix4f, (float)endX, (float)startY, 0.0f).method_22915(r1, g1, b1, a1);
        vertexConsumer.method_22918(matrix4f, (float)endX, (float)startY - 2.0f, 0.0f).method_22915(r1, g1, b1, a1);
        vertexConsumer.method_22918(matrix4f, (float)startX, (float)startY, 0.0f).method_22915(r0, g0, b0, a0);
        vertexConsumer.method_22918(matrix4f, (float)startX, (float)endY, 0.0f).method_22915(r0, g0, b0, a0);
        vertexConsumer.method_22918(matrix4f, (float)endX, (float)endY, 0.0f).method_22915(r1, g1, b1, a1);
        vertexConsumer.method_22918(matrix4f, (float)endX, (float)startY, 0.0f).method_22915(r1, g1, b1, a1);
        vertexConsumer.method_22918(matrix4f, (float)startX, (float)endY, 0.0f).method_22915(r0, g0, b0, a0);
        vertexConsumer.method_22918(matrix4f, (float)startX, (float)endY + 2.0f, 0.0f).method_22915(r1, g1, b1, a1);
        vertexConsumer.method_22918(matrix4f, (float)endX, (float)endY + 2.0f, 0.0f).method_22915(r1, g1, b1, a1);
        vertexConsumer.method_22918(matrix4f, (float)endX, (float)endY, 0.0f).method_22915(r1, g1, b1, a1);
    }
}

